@echo off
SETLOCAL EnableExtensions EnableDelayedExpansion

REM Устанавливаем переменные для хранения путей и ссылок
set DOWNLOAD_URL=https://router.almiki.ru/Windows/releases/almik-rustdesk.dat
set OUTPUT_DIR=%TEMP%\RustDesk
set TEMP_ZIP_FILE="%OUTPUT_DIR%\rustdesk_install.zip"


REM Проверяем существование целевого каталога, создаём, если его нет
if not exist "%OUTPUT_DIR%" (
    md "%OUTPUT_DIR%"
)

REM Скачиваем архив используя bitsadmin (для совместимости с разными версиями Windows)
bitsadmin /transfer AlmikRustDeskDownload /download /priority normal %DOWNLOAD_URL% %TEMP_ZIP_FILE%

REM Проверяем успешность загрузки
if errorlevel 1 (
    echo Ошибка при скачивании архива.
    goto :EOF
)

REM Проверяем наличие PowerShell для распаковки
IF NOT EXIST "%SystemRoot%\system32\WindowsPowerShell\v1.0\powershell.exe" (
    echo Ошибка: PowerShell недоступен. Установка будет прервана.
    del /q %TEMP_ZIP_FILE%
	pause /t 5
    goto :EOF
)

REM Распаковываем архив с помощью PowerShell
powershell Expand-Archive -LiteralPath '%TEMP_ZIP_FILE%' -DestinationPath '%OUTPUT_DIR%' -Force

REM Удаляем временный загруженный архив
del /q %TEMP_ZIP_FILE%

:: Перемещаем папку "RustDesk" в папку Roaming пользователя
IF EXIST "%OUTPUT_DIR%\RustDesk" (
    move /Y "%OUTPUT_DIR%\RustDesk" "%APPDATA%"
)

REM Assign the value random password to the password variable
setlocal ENABLEEXTENSIONS ENABLEDELAYEDEXPANSION
set alfanum=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789
set rustdesk_pw=
for /L %%b in (1, 1, 12) do (
    set /A rnd_num=!RANDOM! %% 62
    for %%c in (!rnd_num!) do (
        set rustdesk_pw=!rustdesk_pw!!alfanum:~%%c,1!
    )
)
set rustdesk_cfg = "0nI9UlcnlVQ5hHUr4EZFREW4hEauNGSUhXNulmQmRXVYNVbXVHWpVXeDdjVNllI6ISeltmIsIiI6ISawFmIsISdy5SarlWbsFmLyVGd19mciojI5FGblJnIsISdy5SarlWbsFmLyVGd19mciojI0N3boJye"


REM ############################### Please Do Not Edit Below This Line #########################################

%OUTPUT_DIR%\Install\rustdesk.exe --silent-install
timeout /t 20 /nobreak

cd "C:\Program Files\RustDesk\"
rustdesk.exe --install-service
timeout /t 20 /nobreak

for /f "delims=" %%i in ('rustdesk.exe --get-id ^| more') do set rustdesk_id=%%i

rustdesk.exe --config 0nI9UlcnlVQ5hHUr4EZFREW4hEauNGSUhXNulmQmRXVYNVbXVHWpVXeDdjVNllI6ISeltmIsIiI6ISawFmIsISdy5SarlWbsFmLyVGd19mciojI5FGblJnIsISdy5SarlWbsFmLyVGd19mciojI0N3boJye
rustdesk.exe --password %rustdesk_pw%

echo ...............................................
REM Show the value of the ID Variable
echo RustDesk ID: %rustdesk_id%

REM Show the value of the Password Variable
echo Password: %rustdesk_pw%
echo ...............................................
rd /Q /S %OUTPUT_DIR%
rd /Q /S %LOCALAPPDATA%\rustdesk
goto :EOF